/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.definition.animation;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.doubles.Double2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.loading.definition.animation.ActorBoneAnimationKeyframe;

@ApiStatus.Internal
public record ActorBoneAnimationEntry(@Nullable ActorBoneAnimationKeyframe soleKeyframe, @Nullable Double2ObjectArrayMap<ActorBoneAnimationKeyframe> keyframes) {
    public boolean isSingleKeyframe() {
        return this.soleKeyframe != null;
    }

    public int size() {
        if (this.isSingleKeyframe()) {
            return 1;
        }
        if (this.keyframes != null) {
            return this.keyframes.size();
        }
        throw new IllegalStateException("ActorBoneAnimationEntry has neither a singular keyframe or a keyframe map. This should never happen!");
    }

    public <T> T mapBoth(Function<ActorBoneAnimationKeyframe, T> soleKeyframeFunction, Function<Double2ObjectArrayMap<ActorBoneAnimationKeyframe>, T> keyframeListFunction) {
        if (this.isSingleKeyframe()) {
            return (T)soleKeyframeFunction.apply((Object)this.soleKeyframe);
        }
        if (this.keyframes != null) {
            return (T)keyframeListFunction.apply(this.keyframes);
        }
        throw new IllegalStateException("ActorBoneAnimationEntry has neither a singular keyframe or a keyframe map. This should never happen!");
    }

    public static JsonDeserializer<ActorBoneAnimationEntry> gsonDeserializer() throws JsonParseException {
        return (json, type, context) -> {
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("vector")) {
                    return new ActorBoneAnimationEntry((ActorBoneAnimationKeyframe)context.deserialize((JsonElement)obj, ActorBoneAnimationKeyframe.class), null);
                }
                Double2ObjectArrayMap keyframes = new Double2ObjectArrayMap(obj.size());
                boolean needsSort = false;
                double lastTime = 0.0;
                for (Map.Entry entry : obj.entrySet()) {
                    try {
                        double timestamp = Double.parseDouble((String)entry.getKey());
                        if (timestamp < lastTime) {
                            GeckoLibConstants.LOGGER.warn("Animation timestamp {} is out of order! Previous timestamp: {}", (Object)timestamp, (Object)lastTime);
                            needsSort = true;
                        }
                        lastTime = timestamp;
                        keyframes.put(timestamp, (Object)((ActorBoneAnimationKeyframe)context.deserialize((JsonElement)entry.getValue(), ActorBoneAnimationKeyframe.class)));
                    }
                    catch (NumberFormatException ex) {
                        throw new JsonParseException("Invalid timestamp, must be a numerical value: " + String.valueOf(entry));
                    }
                }
                if (needsSort) {
                    Double2ObjectArrayMap sortedKeyframes = new Double2ObjectArrayMap(keyframes.size());
                    double[] timestamps = sortedKeyframes.keySet().toDoubleArray();
                    Arrays.sort(timestamps);
                    for (double timestamp : timestamps) {
                        sortedKeyframes.put(timestamp, (Object)((ActorBoneAnimationKeyframe)keyframes.get(timestamp)));
                    }
                    keyframes = sortedKeyframes;
                }
                return new ActorBoneAnimationEntry(null, (Double2ObjectArrayMap<ActorBoneAnimationKeyframe>)keyframes);
            }
            if (json.isJsonPrimitive()) {
                return new ActorBoneAnimationEntry((ActorBoneAnimationKeyframe)context.deserialize(json, ActorBoneAnimationKeyframe.class), null);
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.isEmpty()) {
                    throw new JsonParseException("ActorBoneAnimationEntry has an empty keyframes list. This is an invalid animation json");
                }
                return new ActorBoneAnimationEntry((ActorBoneAnimationKeyframe)context.deserialize(jsonArray.get(0), ActorBoneAnimationKeyframe.class), null);
            }
            throw new JsonParseException("ActorBoneAnimationEntry has an unknown keyframe type: " + String.valueOf(json));
        };
    }
}

